<?php
/* --------------------------------------------------------------
   KlarnaHubPdfOrderExtender.inc.php 2021-08-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class KlarnaHubPdfOrderExtender extends KlarnaHubPdfOrderExtender_parent
{
    public function extendOrderInfo($orderInfo)
    {
        $orderInfo = parent::extendOrderInfo($orderInfo);
        if($_GET['type'] === 'invoice')
        {
            $orderService = StaticGXCoreLoader::getService('OrderRead');
            $order = $orderService->getOrderById(new IdType((int)$_GET['oID']));
            $paymentType = $order->getPaymentType();
            $paymentModule = $paymentType->getModule();
    
            if(in_array($paymentModule, ['KlarnaPaylaterHub', 'KlarnaPaynowHub', 'KlarnaSliceitHub', 'KlarnaBanktransferHub'], true))
            {
                $languageId = $this->v_data_array['order']->info['languages_id'];
                $language = MainFactory::create('LanguageTextManager', 'gambio_hub_klarna_hub', $languageId);
                $orderInfo['KlarnaHub'] = [
                    0 => 'Klarna',
                    1 => $language->get_text('InvoiceNote'),
                ];
        
            }
        }
        return $orderInfo;
    }
    
    public function extendPdfFooter($footer)
    {
        $footer = parent::extendPdfFooter($footer);
    
        if($_GET['type'] === 'invoice')
        {
            $orderService  = StaticGXCoreLoader::getService('OrderRead');
            $order         = $orderService->getOrderById(new IdType((int)$_GET['oID']));
            $paymentType   = $order->getPaymentType();
            $paymentModule = $paymentType->getModule();
    
            if (in_array($paymentModule,
                ['KlarnaPaylaterHub', 'KlarnaPaynowHub', 'KlarnaSliceitHub', 'KlarnaBanktransferHub'], true)) {
        
                $footerReplace = gm_get_conf('PDF_FOOTER_REPLACE_ARRAY');
                if (empty($footerReplace) || $footerReplace === 'null') {
                    $footerReplace = gm_get_conf('PDF_FOOTER_REPLACE_COLUMN');
                }
                $footerColumnsToRemove = explode(', ', (string)$footerReplace);
        
                foreach ($footerColumnsToRemove as $column) {
                    if (is_numeric($column) && isset($footer[(int)$column])) {
                        unset($footer[(int)$column]);
                    }
                }
        
                $footer = array_values($footer);
            }
        }
        
        return $footer;
    }

}
